/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.activiti.web;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricIdentityLink;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.ComboModel;
import org.jeecg.modules.activiti.entity.ActBusiness;
import org.jeecg.modules.activiti.entity.ActZprocess;
import org.jeecg.modules.activiti.entity.ActivitiConstant;
import org.jeecg.modules.activiti.entity.HistoricProcessInsVo;
import org.jeecg.modules.activiti.entity.ProcessInsVo;
import org.jeecg.modules.activiti.entity.ProcessNodeVo;
import org.jeecg.modules.activiti.service.Impl.ActBusinessServiceImpl;
import org.jeecg.modules.activiti.service.Impl.ActZprocessServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/actProcessIns"})
@Transactional
public class ActProcessInsController {
    private static final Logger log = LoggerFactory.getLogger(ActProcessInsController.class);
    @Autowired
    private ActZprocessServiceImpl actZprocessService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ActBusinessServiceImpl actBusinessService;
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private ProcessEngineConfiguration processEngineConfiguration;

    @RequestMapping(value={"/getFirstNode"}, method={RequestMethod.GET})
    public Result getFirstNode(String procDefId) {
        ProcessNodeVo node = this.actZprocessService.getFirstNode(procDefId);
        return Result.ok((Object)node);
    }

    @RequestMapping(value={"/getRunningProcess"}, method={RequestMethod.GET})
    public Result<Object> getRunningProcess(@RequestParam(required=false) String name, @RequestParam(required=false) String categoryId, @RequestParam(required=false) String key) {
        ArrayList list = new ArrayList();
        ProcessInstanceQuery query = (ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessInstanceId().desc();
        if (StrUtil.isNotBlank((CharSequence)name)) {
            query.processInstanceNameLike("%" + name + "%");
        }
        if (StrUtil.isNotBlank((CharSequence)categoryId)) {
            query.processDefinitionCategory(categoryId);
        }
        if (StrUtil.isNotBlank((CharSequence)key)) {
            query.processDefinitionKey(key);
        }
        List processInstanceList = query.list();
        processInstanceList.forEach(e -> list.add(new ProcessInsVo((ProcessInstance)e)));
        List allUser = this.sysBaseAPI.queryAllUser();
        Map<String, String> userMap = allUser.stream().collect(Collectors.toMap(ComboModel::getUsername, ComboModel::getTitle));
        list.forEach(e -> {
            ActBusiness actBusiness;
            List identityLinks = this.historyService.getHistoricIdentityLinksForProcessInstance(e.getId());
            for (HistoricIdentityLink hik : identityLinks) {
                if (!"starter".equals(hik.getType()) || !StrUtil.isNotBlank((CharSequence)hik.getUserId())) continue;
                e.setApplyer((String)userMap.get(hik.getUserId()));
            }
            List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(e.getProcInstId())).list();
            if (taskList != null && taskList.size() == 1) {
                e.setCurrTaskName(((Task)taskList.get(0)).getName());
            } else if (taskList != null && taskList.size() > 1) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < taskList.size() - 1; ++i) {
                    sb.append(((Task)taskList.get(i)).getName() + "\u3001");
                }
                sb.append(((Task)taskList.get(taskList.size() - 1)).getName());
                e.setCurrTaskName(sb.toString());
            }
            ActZprocess actProcess = (ActZprocess)this.actZprocessService.getById((Serializable)((Object)e.getProcDefId()));
            if (actProcess != null) {
                e.setRouteName(actProcess.getRouteName());
            }
            if ((actBusiness = (ActBusiness)this.actBusinessService.getById((Serializable)((Object)e.getBusinessKey()))) != null) {
                e.setTableId(actBusiness.getTableId());
                e.setTableName(actBusiness.getTableName());
            }
        });
        return Result.ok(list);
    }

    @RequestMapping(value={"/delInsByIds/{ids}"})
    public Result<Object> delInsByIds(@PathVariable String ids, @RequestParam(required=false) String reason) {
        if (StrUtil.isBlank((CharSequence)reason)) {
            reason = "";
        }
        for (String id : ids.split(",")) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(id).singleResult();
            ActBusiness actBusiness = (ActBusiness)this.actBusinessService.getById((Serializable)((Object)pi.getBusinessKey()));
            actBusiness.setStatus(ActivitiConstant.STATUS_TO_APPLY);
            actBusiness.setResult(ActivitiConstant.RESULT_TO_SUBMIT);
            this.actBusinessService.updateById(actBusiness);
            this.runtimeService.deleteProcessInstance(id, "deleted-" + reason);
        }
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/updateInsStatus"}, method={RequestMethod.POST})
    public Result<Object> updateStatus(@RequestParam String id, @RequestParam Integer status) {
        if (ActivitiConstant.PROCESS_STATUS_ACTIVE.equals(status)) {
            this.runtimeService.activateProcessInstanceById(id);
        } else if (ActivitiConstant.PROCESS_STATUS_SUSPEND.equals(status)) {
            this.runtimeService.suspendProcessInstanceById(id);
        }
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/getFinishedProcess"}, method={RequestMethod.GET})
    public Result<Object> getFinishedProcess(@RequestParam(required=false) String name, @RequestParam(required=false) String categoryId, @RequestParam(required=false) String key, String startDate, String endDate) {
        ArrayList list = new ArrayList();
        HistoricProcessInstanceQuery query = (HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().finished().orderByProcessInstanceEndTime().desc();
        if (StrUtil.isNotBlank((CharSequence)name)) {
            query.processInstanceNameLike("%" + name + "%");
        }
        if (StrUtil.isNotBlank((CharSequence)categoryId)) {
            query.processDefinitionCategory(categoryId);
        }
        if (StrUtil.isNotBlank((CharSequence)key)) {
            query.processDefinitionKey(key);
        }
        if (StrUtil.isNotBlank((CharSequence)startDate) && StrUtil.isNotBlank((CharSequence)endDate)) {
            DateTime start = DateUtil.parse((CharSequence)startDate);
            DateTime end = DateUtil.parse((CharSequence)endDate);
            query.finishedAfter((Date)start);
            query.finishedBefore((Date)DateUtil.endOfDay((Date)end));
        }
        List processInstanceList = query.list();
        processInstanceList.forEach(e -> list.add(new HistoricProcessInsVo((HistoricProcessInstance)e)));
        List allUser = this.sysBaseAPI.queryAllUser();
        Map<String, String> userMap = allUser.stream().collect(Collectors.toMap(ComboModel::getUsername, ComboModel::getTitle));
        list.forEach(e -> {
            ActBusiness actBusiness;
            List identityLinks = this.historyService.getHistoricIdentityLinksForProcessInstance(e.getId());
            for (HistoricIdentityLink hik : identityLinks) {
                if (!"starter".equals(hik.getType()) || !StrUtil.isNotBlank((CharSequence)hik.getUserId())) continue;
                e.setApplyer((String)userMap.get(hik.getUserId()));
            }
            ActZprocess actProcess = (ActZprocess)this.actZprocessService.getById((Serializable)((Object)e.getProcDefId()));
            if (actProcess != null) {
                e.setRouteName(actProcess.getRouteName());
            }
            if ((actBusiness = (ActBusiness)this.actBusinessService.getById((Serializable)((Object)e.getBusinessKey()))) != null) {
                e.setTableId(actBusiness.getTableId());
                e.setTableName(actBusiness.getTableName());
                String reason = e.getDeleteReason();
                if (reason == null) {
                    e.setResult(ActivitiConstant.RESULT_PASS);
                } else if (reason.contains("canceled-")) {
                    e.setResult(ActivitiConstant.RESULT_CANCEL);
                    if (reason.length() > 9) {
                        e.setDeleteReason(reason.substring(9));
                    } else {
                        e.setDeleteReason("");
                    }
                } else if ("backed".equals(reason)) {
                    e.setResult(ActivitiConstant.RESULT_FAIL);
                    e.setDeleteReason("");
                } else if (reason.contains("deleted-")) {
                    e.setResult(ActivitiConstant.RESULT_DELETED);
                    if (reason.length() > 8) {
                        e.setDeleteReason(reason.substring(8));
                    } else {
                        e.setDeleteReason("");
                    }
                } else {
                    e.setResult(ActivitiConstant.RESULT_PASS);
                }
            }
        });
        return Result.ok(list);
    }

    @RequestMapping(value={"/delHistoricInsByIds/{ids}"})
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664\u5df2\u7ed3\u675f\u7684\u5b9e\u4f8b")
    public Result<Object> delHistoricInsByIds(@PathVariable String ids) {
        for (String id : ids.split(",")) {
            this.historyService.deleteHistoricProcessInstance(id);
        }
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }
}

