/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.activiti.web;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.activiti.entity.ActBusiness;
import org.jeecg.modules.activiti.entity.ActZprocess;
import org.jeecg.modules.activiti.entity.ActivitiConstant;
import org.jeecg.modules.activiti.mapper.ActBusinessMapper;
import org.jeecg.modules.activiti.service.Impl.ActBusinessServiceImpl;
import org.jeecg.modules.activiti.service.Impl.ActZprocessServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/actBusiness"})
@Transactional
public class ActBusinessController {
    private static final Logger log = LoggerFactory.getLogger(ActBusinessController.class);
    @Autowired
    ActBusinessServiceImpl actBusinessService;
    @Autowired
    ActZprocessServiceImpl actZprocessService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    ISysBaseAPI sysBaseAPI;

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result add(HttpServletRequest request) {
        String procDefId = request.getParameter("procDefId");
        String procDeTitle = request.getParameter("procDeTitle");
        String tableName = request.getParameter("tableName");
        String tableId = IdUtil.simpleUUID();
        this.actBusinessService.saveApplyForm(tableId, request);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String username = sysUser.getUsername();
        ActBusiness actBusiness = new ActBusiness();
        actBusiness.setUserId(username);
        actBusiness.setTableId(tableId);
        actBusiness.setProcDefId(procDefId);
        String title = request.getParameter("title");
        if (StrUtil.isNotBlank((CharSequence)title)) {
            actBusiness.setTitle(title);
        } else {
            actBusiness.setTitle(procDeTitle);
        }
        actBusiness.setTableName(tableName);
        this.actBusinessService.save(actBusiness);
        return Result.ok();
    }

    @RequestMapping(value={"/getForm"}, method={RequestMethod.GET})
    public Result getForm(HttpServletRequest request) {
        String tableId = request.getParameter("tableId");
        String tableName = request.getParameter("tableName");
        if (StrUtil.isBlank((CharSequence)tableName)) {
            return Result.error((String)"\u53c2\u6570\u7f3a\u7701\uff01");
        }
        Map<String, Object> applyForm = this.actBusinessService.getApplyForm(tableId, tableName);
        return Result.ok(applyForm);
    }

    @RequestMapping(value={"/editForm"}, method={RequestMethod.POST})
    public Result editForm(HttpServletRequest request) {
        String tableId = request.getParameter("id");
        this.actBusinessService.saveApplyForm(tableId, request);
        return Result.ok();
    }

    @RequestMapping(value={"/delByIds"}, method={RequestMethod.POST})
    public Result delByIds(String ids) {
        for (String id : ids.split(",")) {
            ActBusiness actBusiness = (ActBusiness)this.actBusinessService.getById((Serializable)((Object)id));
            if (actBusiness.getStatus() != ActivitiConstant.STATUS_TO_APPLY) {
                return Result.error((String)"\u5220\u9664\u5931\u8d25, \u4ec5\u80fd\u5220\u9664\u8349\u7a3f\u72b6\u6001\u7684\u7533\u8bf7");
            }
            this.actBusinessService.deleteBusiness(actBusiness.getTableName(), actBusiness.getTableId());
            this.actBusinessService.removeById((Serializable)((Object)id));
        }
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/apply"}, method={RequestMethod.POST})
    public Result apply(ActBusiness act) {
        ActBusiness actBusiness = (ActBusiness)this.actBusinessService.getById((Serializable)((Object)act.getId()));
        if (actBusiness == null) {
            return Result.error((String)"actBusiness\u8868\u4e2d\u8be5id\u4e0d\u5b58\u5728");
        }
        String tableId = actBusiness.getTableId();
        String tableName = actBusiness.getTableName();
        act.setTableId(tableId);
        Map<String, Object> busiData = ((ActBusinessMapper)this.actBusinessService.getBaseMapper()).getBusiData(tableId, tableName);
        if (MapUtil.isNotEmpty(busiData) && busiData.get("title") != null) {
            actBusiness.setTitle(busiData.get("title") + "");
        }
        String processInstanceId = this.actZprocessService.startProcess(act);
        actBusiness.setProcInstId(processInstanceId);
        actBusiness.setStatus(ActivitiConstant.STATUS_DEALING);
        actBusiness.setResult(ActivitiConstant.RESULT_DEALING);
        actBusiness.setApplyTime(new Date());
        this.actBusinessService.updateById(actBusiness);
        this.actBusinessService.updateBusinessStatus(actBusiness.getTableName(), actBusiness.getTableId(), "\u542f\u52a8");
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    public Result<Object> cancel(@RequestParam String id, @RequestParam String procInstId, @RequestParam(required=false) String reason) {
        if (StrUtil.isBlank((CharSequence)reason)) {
            reason = "";
        }
        this.runtimeService.deleteProcessInstance(procInstId, "canceled-" + reason);
        ActBusiness actBusiness = (ActBusiness)this.actBusinessService.getById((Serializable)((Object)id));
        actBusiness.setStatus(ActivitiConstant.STATUS_CANCELED);
        actBusiness.setResult(ActivitiConstant.RESULT_TO_SUBMIT);
        this.actBusinessService.updateById(actBusiness);
        this.actBusinessService.updateBusinessStatus(actBusiness.getTableName(), actBusiness.getTableId(), "\u64a4\u56de");
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/listData"})
    public Result listData(ActBusiness param, HttpServletRequest request) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByDesc(ActBusiness::getCreateTime);
        if (StrUtil.isNotBlank((CharSequence)param.getTitle())) {
            queryWrapper.like(ActBusiness::getTitle, (Object)param.getTitle());
        }
        if (param.getStatus() != null) {
            queryWrapper.eq(ActBusiness::getStatus, (Object)param.getStatus());
        }
        if (param.getResult() != null) {
            queryWrapper.eq(ActBusiness::getResult, (Object)param.getResult());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getParameter("createTime_begin"))) {
            queryWrapper.ge(ActBusiness::getTitle, (Object)param.getTitle());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getParameter("createTime_end"))) {
            queryWrapper.le(ActBusiness::getTitle, (Object)param.getTitle());
        }
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        queryWrapper.eq(ActBusiness::getUserId, (Object)loginUser.getUsername());
        List actBusinessList = this.actBusinessService.list((Wrapper)queryWrapper);
        actBusinessList.forEach(e -> {
            if (StrUtil.isNotBlank((CharSequence)e.getProcDefId())) {
                ActZprocess actProcess = (ActZprocess)this.actZprocessService.getById((Serializable)((Object)e.getProcDefId()));
                e.setRouteName(actProcess.getRouteName());
                e.setProcessName(actProcess.getName());
            }
            if (ActivitiConstant.STATUS_DEALING.equals(e.getStatus())) {
                List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(e.getProcInstId())).list();
                if (taskList != null && taskList.size() == 1) {
                    e.setCurrTaskName(((Task)taskList.get(0)).getName());
                } else if (taskList != null && taskList.size() > 1) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < taskList.size() - 1; ++i) {
                        sb.append(((Task)taskList.get(i)).getName() + "\u3001");
                    }
                    sb.append(((Task)taskList.get(taskList.size() - 1)).getName());
                    e.setCurrTaskName(sb.toString());
                }
            }
        });
        return Result.ok((Object)actBusinessList);
    }
}

