/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.activiti.service.Impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.modules.activiti.entity.ActBusiness;
import org.jeecg.modules.activiti.entity.ActZprocess;
import org.jeecg.modules.activiti.entity.ActivitiConstant;
import org.jeecg.modules.activiti.entity.Department;
import org.jeecg.modules.activiti.entity.ProcessNodeVo;
import org.jeecg.modules.activiti.entity.Role;
import org.jeecg.modules.activiti.mapper.ActBusinessMapper;
import org.jeecg.modules.activiti.mapper.ActZprocessMapper;
import org.jeecg.modules.activiti.service.IActZprocessService;
import org.jeecg.modules.activiti.service.Impl.ActBusinessServiceImpl;
import org.jeecg.modules.activiti.service.Impl.ActNodeServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class ActZprocessServiceImpl
extends ServiceImpl<ActZprocessMapper, ActZprocess>
implements IActZprocessService {
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ActNodeServiceImpl actNodeService;
    @Autowired
    private ActBusinessServiceImpl actBusinessService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ISysBaseAPI sysBaseAPI;

    public void setAllOldByProcessKey(String processKey) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(ActZprocess::getProcessKey, (Object)processKey));
        if (list == null || list.size() == 0) {
            return;
        }
        list.forEach(item -> item.setLatest(false));
        this.updateBatchById(list);
    }

    public void setLatestByProcessKey(String processKey) {
        ActZprocess actProcess = this.findTopByProcessKeyOrderByVersionDesc(processKey);
        if (actProcess == null) {
            return;
        }
        actProcess.setLatest(true);
        this.updateById(actProcess);
    }

    private ActZprocess findTopByProcessKeyOrderByVersionDesc(String processKey) {
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActZprocess::getProcessKey, (Object)processKey)).orderByDesc(ActZprocess::getVersion));
        if (CollUtil.isNotEmpty((Collection)list)) {
            return (ActZprocess)list.get(0);
        }
        return null;
    }

    public String startProcess(ActBusiness actBusiness) {
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.identityService.setAuthenticatedUserId(loginUser.getUsername());
        Map<String, Object> params = actBusiness.getParams();
        params.put("tableId", actBusiness.getTableId());
        ActBusiness act = (ActBusiness)this.actBusinessService.getById((Serializable)((Object)actBusiness.getId()));
        String tableName = act.getTableName();
        String tableId = act.getTableId();
        if (StrUtil.isBlank((CharSequence)tableId) || StrUtil.isBlank((CharSequence)tableName)) {
            throw new JeecgBootException("\u6ca1\u6709\u4e1a\u52a1\u8868\u5355\u6570\u636e");
        }
        Map<String, Object> busiData = ((ActBusinessMapper)this.actBusinessService.getBaseMapper()).getBusiData(tableId, tableName);
        for (String key : busiData.keySet()) {
            params.put(key, busiData.get(key));
        }
        ProcessInstance pi = this.runtimeService.startProcessInstanceById(actBusiness.getProcDefId(), actBusiness.getId(), params);
        this.runtimeService.setProcessInstanceName(pi.getId(), actBusiness.getTitle());
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId())).list();
        for (Task task : tasks) {
            if (actBusiness.getFirstGateway().booleanValue()) {
                List<LoginUser> users = this.getNode(task.getTaskDefinitionKey()).getUsers();
                if (users == null || users.size() == 0) {
                    throw new RuntimeException("\u4efb\u52a1\u8282\u70b9\u672a\u5206\u914d\u4efb\u4f55\u5019\u9009\u5ba1\u6279\u4eba\uff0c\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25");
                }
                for (LoginUser user : users) {
                    this.taskService.addCandidateUser(task.getId(), user.getUsername());
                    this.sendActMessage(loginUser, user, actBusiness, task.getName(), actBusiness.getSendMessage(), actBusiness.getSendSms(), actBusiness.getSendEmail());
                }
            } else {
                String assignees = actBusiness.getAssignees();
                for (String assignee : assignees.split(",")) {
                    this.taskService.addCandidateUser(task.getId(), assignee);
                    LoginUser user = this.sysBaseAPI.getUserByName(assignee);
                    this.sendActMessage(loginUser, user, actBusiness, task.getName(), actBusiness.getSendMessage(), actBusiness.getSendSms(), actBusiness.getSendEmail());
                }
            }
            this.taskService.setPriority(task.getId(), actBusiness.getPriority().intValue());
        }
        return pi.getId();
    }

    public void sendActMessage(LoginUser fromUser, LoginUser toUser, ActBusiness act, String taskName, Boolean sendMessage, Boolean sendSms, Boolean sendEmail) {
        String title = String.format("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u5ba1\u6279\u4efb\u52a1", new Object[0]);
        HashMap msgMap = Maps.newHashMap();
        msgMap.put("bpm_name", act.getTitle());
        msgMap.put("bpm_task", taskName);
        msgMap.put("datetime", DateUtils.now());
        msgMap.put("remark", "\u8bf7\u8fdb\u5165\u5f85\u529e\u680f\uff0c\u5c3d\u5feb\u5904\u7406\uff01");
        String msgText = this.sysBaseAPI.parseTemplateByCode("bpm_cuiban", (Map)msgMap);
        this.sendMessage(fromUser, toUser, title, msgText, sendMessage, sendSms, sendEmail);
    }

    public void sendMessage(LoginUser fromUser, LoginUser toUser, String title, String msgText, Boolean sendMessage, Boolean sendSms, Boolean sendEmail) {
        if (sendMessage != null && sendMessage.booleanValue()) {
            this.sysBaseAPI.sendSysAnnouncement(fromUser.getUsername(), toUser.getUsername(), title, msgText);
        }
        if (sendSms == null || !sendSms.booleanValue() || StrUtil.isNotBlank((CharSequence)toUser.getPhone())) {
            // empty if block
        }
        if (sendEmail != null && sendEmail.booleanValue() && StrUtil.isNotBlank((CharSequence)toUser.getEmail())) {
            JavaMailSender mailSender = (JavaMailSender)SpringContextUtils.getBean((String)"mailSender");
            SimpleMailMessage message = new SimpleMailMessage();
            message.setTo(toUser.getEmail());
            message.setText(msgText);
            mailSender.send(message);
        }
    }

    public ProcessNodeVo getNode(String nodeId) {
        ProcessNodeVo node = new ProcessNodeVo();
        List<LoginUser> users = this.getNodetUsers(nodeId);
        node.setUsers(this.removeDuplicate(users));
        return node;
    }

    public List<LoginUser> getNodetUsers(String nodeId) {
        List<Object> users = this.actNodeService.findUserByNodeId(nodeId);
        List<Role> roles = this.actNodeService.findRoleByNodeId(nodeId);
        for (Role role : roles) {
            List<LoginUser> userList = this.actNodeService.findUserByRoleId(role.getId());
            users.addAll(userList);
        }
        List<Department> departments = this.actNodeService.findDepartmentByNodeId(nodeId);
        for (Department d : departments) {
            List<LoginUser> userList = this.actNodeService.findUserDepartmentId(d.getId());
            users.addAll(userList);
        }
        if (this.actNodeService.hasChooseDepHeader(nodeId).booleanValue()) {
            List<LoginUser> list = this.actNodeService.queryAllUser();
            LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            List departIds = this.sysBaseAPI.getDepartIdsByUsername(loginUser.getUsername());
            for (String departId : departIds) {
                List collect = list.stream().filter(u -> u.getDepartIds() != null && u.getDepartIds().indexOf(departId) > -1).collect(Collectors.toList());
                users.addAll(collect);
            }
        }
        if (this.actNodeService.hasChooseSponsor(nodeId).booleanValue()) {
            LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            users.add(loginUser);
        }
        users = users.stream().filter(u -> StrUtil.equals((CharSequence)"0", (CharSequence)(u.getDelFlag() + ""))).collect(Collectors.toList());
        return users;
    }

    private List<LoginUser> removeDuplicate(List<LoginUser> list) {
        LinkedHashSet<LoginUser> set = new LinkedHashSet<LoginUser>(list.size());
        set.addAll(list);
        list.clear();
        list.addAll(set);
        this.entityManager.clear();
        list.forEach(u -> u.setPassword(null));
        return list;
    }

    public ProcessNodeVo getFirstNode(String procDefId) {
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procDefId);
        ProcessNodeVo node = new ProcessNodeVo();
        List processes = bpmnModel.getProcesses();
        Collection elements = ((Process)processes.get(0)).getFlowElements();
        StartEvent startEvent = null;
        for (FlowElement element : elements) {
            if (!(element instanceof StartEvent)) continue;
            startEvent = (StartEvent)element;
            break;
        }
        FlowElement e = null;
        SequenceFlow sequenceFlow = (SequenceFlow)startEvent.getOutgoingFlows().get(0);
        for (FlowElement element : elements) {
            if (!element.getId().equals(sequenceFlow.getTargetRef())) continue;
            if (element instanceof UserTask) {
                e = element;
                node.setType(1);
                break;
            }
            if (element instanceof ExclusiveGateway) {
                e = element;
                node.setType(3);
                break;
            }
            if (element instanceof ParallelGateway) {
                e = element;
                node.setType(4);
                break;
            }
            throw new RuntimeException("\u6d41\u7a0b\u8bbe\u8ba1\u9519\u8bef\uff0c\u5f00\u59cb\u8282\u70b9\u540e\u53ea\u80fd\u662f\u7528\u6237\u4efb\u52a1\u8282\u70b9\u3001\u6392\u4ed6\u7f51\u5173\u3001\u5e76\u884c\u7f51\u5173");
        }
        if (e instanceof ExclusiveGateway || e instanceof ParallelGateway) {
            return node;
        }
        node.setTitle(e.getName());
        List<LoginUser> users = this.getNodetUsers(e.getId());
        node.setUsers(this.removeDuplicate(users));
        return node;
    }

    public ProcessNodeVo getNextNode(String procDefId, String currActId) {
        ProcessNodeVo node = new ProcessNodeVo();
        ProcessDefinitionEntity dfe = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(procDefId);
        List activitiList = dfe.getActivities();
        for (ActivityImpl activityImpl : activitiList) {
            if (!activityImpl.getId().equals(currActId)) continue;
            List pvmTransitions = activityImpl.getOutgoingTransitions();
            PvmActivity pvmActivity = ((PvmTransition)pvmTransitions.get(0)).getDestination();
            String type = pvmActivity.getProperty("type").toString();
            if ("userTask".equals(type)) {
                node.setType(ActivitiConstant.NODE_TYPE_TASK);
                node.setTitle(pvmActivity.getProperty("name").toString());
                List<LoginUser> users = this.getNodetUsers(pvmActivity.getId());
                node.setUsers(this.removeDuplicate(users));
                break;
            }
            if ("exclusiveGateway".equals(type)) {
                node.setType(ActivitiConstant.NODE_TYPE_EG);
                break;
            }
            if ("parallelGateway".equals(type)) {
                node.setType(ActivitiConstant.NODE_TYPE_PG);
                break;
            }
            if ("endEvent".equals(type)) {
                node.setType(ActivitiConstant.NODE_TYPE_END);
                break;
            }
            throw new JeecgBootException("\u6d41\u7a0b\u8bbe\u8ba1\u9519\u8bef\uff0c\u5305\u542b\u65e0\u6cd5\u5904\u7406\u7684\u8282\u70b9");
        }
        return node;
    }
}

