/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.activiti.service.Impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.activiti.entity.ActNode;
import org.jeecg.modules.activiti.entity.Department;
import org.jeecg.modules.activiti.entity.Role;
import org.jeecg.modules.activiti.mapper.ActNodeMapper;
import org.jeecg.modules.activiti.service.IActNodeService;
import org.springframework.stereotype.Service;

@Service
public class ActNodeServiceImpl
extends ServiceImpl<ActNodeMapper, ActNode>
implements IActNodeService {
    public List<String> getRoleByUserName(String username) {
        return ((ActNodeMapper)this.baseMapper).getRoleByUserName(username);
    }

    public void deleteByNodeId(String id) {
        this.remove((Wrapper)new LambdaQueryWrapper().eq(ActNode::getNodeId, (Object)id));
    }

    public List<LoginUser> findUserByNodeId(String nodeId) {
        ArrayList users = ((ActNodeMapper)this.baseMapper).findUserByNodeId(nodeId);
        if (users.size() == 0) {
            users = Lists.newArrayList();
        }
        return users;
    }

    public List<Role> findRoleByNodeId(String nodeId) {
        return ((ActNodeMapper)this.baseMapper).findRoleByNodeId(nodeId);
    }

    public List<Department> findDepartmentByNodeId(String nodeId) {
        return ((ActNodeMapper)this.baseMapper).findDepartmentByNodeId(nodeId);
    }

    public Boolean hasChooseDepHeader(String nodeId) {
        List<ActNode> listNode = this.findByNodeIdAndType(nodeId, 4);
        if (listNode != null && listNode.size() > 0) {
            return true;
        }
        return false;
    }

    public Boolean hasChooseSponsor(String nodeId) {
        List<ActNode> listNode = this.findByNodeIdAndType(nodeId, 3);
        if (listNode != null && listNode.size() > 0) {
            return true;
        }
        return false;
    }

    public List<ActNode> findByNodeIdAndType(String nodeId, int type) {
        return this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActNode::getNodeId, (Object)nodeId)).eq(ActNode::getType, (Object)type));
    }

    public List<String> findDepartmentIdsByNodeId(String nodeId) {
        List<Department> departmentByNodeId = this.findDepartmentByNodeId(nodeId);
        return departmentByNodeId.stream().map(Department::getId).distinct().collect(Collectors.toList());
    }

    public List<LoginUser> queryAllUser() {
        return ((ActNodeMapper)this.baseMapper).queryAllUser();
    }

    public List<LoginUser> findUserByRoleId(String id) {
        return ((ActNodeMapper)this.baseMapper).findUserByRoleId(id);
    }

    public List<LoginUser> findUserDepartmentId(String id) {
        return ((ActNodeMapper)this.baseMapper).findUserDepartmentId(id);
    }
}

