/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config;

import com.alibaba.druid.pool.DruidDataSource;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.activiti.spring.boot.AbstractProcessEngineAutoConfiguration;
import org.jeecg.config.ActivitiDataSourceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class ActivitiDataSourceConfig
extends AbstractProcessEngineAutoConfiguration {
    @Resource
    private ActivitiDataSourceProperties activitiDataSourceProperties;

    @Bean
    public DataSource activitiDataSource() {
        DruidDataSource DruiddataSource = new DruidDataSource();
        DruiddataSource.setUrl(this.activitiDataSourceProperties.getUrl());
        DruiddataSource.setDriverClassName(this.activitiDataSourceProperties.getDriverClassName());
        DruiddataSource.setPassword(this.activitiDataSourceProperties.getPassword());
        DruiddataSource.setUsername(this.activitiDataSourceProperties.getUsername());
        return DruiddataSource;
    }

    @Bean
    public PlatformTransactionManager transactionManager() {
        return new DataSourceTransactionManager(this.activitiDataSource());
    }

    @Bean
    public SpringProcessEngineConfiguration springProcessEngineConfiguration() {
        SpringProcessEngineConfiguration configuration = new SpringProcessEngineConfiguration();
        configuration.setDataSource(this.activitiDataSource());
        configuration.setDatabaseSchemaUpdate("true");
        configuration.setJobExecutorActivate(true);
        configuration.setTransactionManager(this.transactionManager());
        configuration.setActivityFontName("\u5b8b\u4f53");
        configuration.setLabelFontName("\u5b8b\u4f53");
        configuration.setAnnotationFontName("\u5b8b\u4f53");
        return configuration;
    }
}

