/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import us.codecraft.webmagic.selector.RegexResult;
import us.codecraft.webmagic.selector.Selector;

public class RegexSelector
implements Selector {
    private String regexStr;
    private Pattern regex;
    private int group = 1;

    public RegexSelector(String regexStr, int group) {
        this.compileRegex(regexStr);
        this.group = group;
    }

    private void compileRegex(String regexStr) {
        if (StringUtils.isBlank((CharSequence)regexStr)) {
            throw new IllegalArgumentException("regex must not be empty");
        }
        try {
            this.regex = Pattern.compile(regexStr, 34);
            this.regexStr = regexStr;
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("invalid regex " + regexStr, e);
        }
    }

    public RegexSelector(String regexStr) {
        this.compileRegex(regexStr);
        this.group = this.regex.matcher("").groupCount() == 0 ? 0 : 1;
    }

    @Override
    public String select(String text) {
        return this.selectGroup(text).get(this.group);
    }

    @Override
    public List<String> selectList(String text) {
        ArrayList<String> strings = new ArrayList<String>();
        List<RegexResult> results = this.selectGroupList(text);
        for (RegexResult result : results) {
            strings.add(result.get(this.group));
        }
        return strings;
    }

    public RegexResult selectGroup(String text) {
        Matcher matcher = this.regex.matcher(text);
        if (matcher.find()) {
            String[] groups = new String[matcher.groupCount() + 1];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = matcher.group(i);
            }
            return new RegexResult(groups);
        }
        return RegexResult.EMPTY_RESULT;
    }

    public List<RegexResult> selectGroupList(String text) {
        Matcher matcher = this.regex.matcher(text);
        ArrayList<RegexResult> resultList = new ArrayList<RegexResult>();
        while (matcher.find()) {
            String[] groups = new String[matcher.groupCount() + 1];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = matcher.group(i);
            }
            resultList.add(new RegexResult(groups));
        }
        return resultList;
    }

    public String toString() {
        return this.regexStr;
    }
}

